# Modificações - Suporte para .pag e Injeção em Área Segura

## Resumo das Alterações

Esta versão modificada da ferramenta de alteração de hash agora suporta arquivos `.pag` além de `.exe` e `.dll`, com estratégias de injeção de dados em áreas seguras para evitar corromper a estrutura e criptografia dos arquivos.

## Novas Funcionalidades

### 1. Suporte para Arquivos .pag

A ferramenta agora aceita e processa arquivos com extensão `.pag`, aplicando uma estratégia de injeção específica para este formato.

### 2. Estratégias de Injeção em Área Segura

A ferramenta implementa duas estratégias diferentes de injeção de dados, dependendo do tipo de arquivo:

#### Para Arquivos .exe e .dll (Formato PE)
- **Método**: Injeção no padding do header PE
- **Offset**: 1024 bytes do início do arquivo
- **Razão**: Os arquivos PE (Portable Executable) possuem uma área de padding no header que pode ser modificada sem afetar a execução do programa
- **Vantagem**: Mantém o tamanho original do arquivo

#### Para Arquivos .pag
- **Método**: Append (anexar ao final do arquivo)
- **Offset**: Final do arquivo original
- **Razão**: Para formatos desconhecidos ou proprietários, a área mais segura é o final do arquivo, funcionando como uma "área de padding"
- **Vantagem**: Não interfere com a estrutura interna do arquivo, apenas adiciona dados extras ao final

## Dados Injetados

Cada modificação injeta **24 bytes** de dados únicos:
- **16 bytes**: Timestamp atual (em formato string)
- **8 bytes**: Dados aleatórios criptograficamente seguros

Esta combinação garante que:
1. Cada modificação gera um hash completamente diferente
2. O hash nunca se repete (devido ao timestamp + aleatoriedade)
3. Os dados injetados não corrompem a funcionalidade do arquivo

## Arquivos Modificados

### Frontend (client/src/pages/Home.tsx)
- Adicionada validação para arquivos `.pag`
- Implementada lógica de detecção de tipo de arquivo
- Adicionada estratégia condicional de injeção (append para .pag, offset para .exe/.dll)
- Atualizada interface do usuário com informações sobre as estratégias de injeção

### Backend (server/routers.ts)
- Adicionado parâmetro `fileName` para detectar o tipo de arquivo
- Implementada lógica de injeção condicional no servidor
- Adicionados campos de retorno: `injectionMethod`, `originalSize`, `finalSize`
- Atualizada documentação dos comentários no código

## Como Usar

1. **Selecione um arquivo**: `.exe`, `.dll` ou `.pag`
2. **Clique em "Modificar Hash"**: A ferramenta detectará automaticamente o tipo de arquivo
3. **Aguarde o processamento**: O hash será alterado usando a estratégia apropriada
4. **Baixe o arquivo modificado**: O arquivo mantém sua funcionalidade original

## Segurança e Integridade

### Por que estas áreas são seguras?

#### Arquivos PE (.exe/.dll)
O offset 1024 está localizado no **padding do header PE**, uma área reservada mas não utilizada pela maioria dos executáveis. Modificar esta área:
- ✅ Não afeta o código executável
- ✅ Não altera as seções de dados
- ✅ Não corrompe assinaturas digitais (que são recalculadas separadamente)
- ✅ Não interfere com recursos embutidos

#### Arquivos .pag
Anexar dados ao final do arquivo:
- ✅ Não modifica a estrutura interna
- ✅ Não afeta a leitura sequencial do arquivo
- ✅ Funciona como "metadata" adicional
- ✅ Pode ser facilmente removido se necessário (truncando o arquivo)

### Limitações e Avisos

⚠️ **Assinaturas Digitais**: Se o arquivo `.exe` ou `.dll` estiver assinado digitalmente, a modificação invalidará a assinatura. Você precisará reassinar o arquivo após a modificação.

⚠️ **Arquivos .pag**: Como o formato `.pag` pode variar dependendo da aplicação, teste sempre o arquivo modificado para garantir que funciona corretamente.

⚠️ **Tamanho do Arquivo**: Para arquivos `.pag`, o tamanho final será 24 bytes maior que o original devido ao método de append.

## Exemplos de Uso

### Exemplo 1: Modificar um instalador .exe
```
Arquivo original: installer.exe (5.2 MB)
Hash original: a1b2c3d4e5f6...
Método: PE header padding (offset 1024)
Arquivo modificado: installer.exe (5.2 MB - mesmo tamanho)
Hash modificado: 9f8e7d6c5b4a...
```

### Exemplo 2: Modificar um arquivo .pag
```
Arquivo original: data.pag (1.8 MB)
Hash original: 1a2b3c4d5e6f...
Método: Append to end
Arquivo modificado: data.pag (1.8 MB + 24 bytes)
Hash modificado: f6e5d4c3b2a1...
```

## Detalhes Técnicos

### Estrutura dos Dados Injetados
```
[16 bytes: timestamp] + [8 bytes: random]
Exemplo: "1730073600000000" + [0xA3, 0x7F, 0x2E, 0x91, 0x5C, 0x48, 0xD2, 0x1B]
```

### Cálculo do Hash
- **Algoritmo**: SHA-256
- **Entrada**: Todo o conteúdo do arquivo modificado
- **Saída**: Hash hexadecimal de 64 caracteres

## Compatibilidade

- ✅ Windows (executáveis PE)
- ✅ Qualquer formato de arquivo .pag
- ✅ Bibliotecas DLL de 32 e 64 bits
- ✅ Executáveis .exe de 32 e 64 bits

## Suporte

Para questões ou problemas, consulte o código-fonte ou entre em contato com o desenvolvedor.

---

**Versão**: 2.0 (com suporte .pag e injeção em área segura)  
**Data**: Outubro 2024

