# Guia Rápido - Modificador de Hash com Suporte .pag

## Instalação e Execução

### 1. Instalar Dependências
```bash
cd exe_hash_modifier
pnpm install
```

### 2. Executar em Modo Desenvolvimento
```bash
pnpm dev
```

A aplicação estará disponível em: `http://localhost:5000`

### 3. Build para Produção
```bash
pnpm build
pnpm start
```

## Como Usar

### Passo 1: Selecionar Arquivo
- Clique na área de upload ou arraste um arquivo
- Formatos suportados: `.exe`, `.dll`, `.pag`

### Passo 2: Visualizar Hash Original
- O hash SHA-256 original será calculado automaticamente
- Você pode copiar o hash clicando no botão de copiar

### Passo 3: Modificar o Hash
- Clique no botão "Modificar Hash"
- A ferramenta aplicará a estratégia apropriada:
  - **Arquivos .exe/.dll**: Injeção no offset 1024 (padding do header PE)
  - **Arquivos .pag**: Append ao final do arquivo

### Passo 4: Baixar Arquivo Modificado
- O novo hash será exibido
- Clique em "Baixar Arquivo Modificado" para salvar

## Diferenças entre os Métodos

### Método PE Header Padding (.exe/.dll)
```
┌─────────────────────────────────────┐
│ PE Header (0-1024)                  │
│ ├─ DOS Header                       │
│ ├─ PE Signature                     │
│ ├─ COFF Header                      │
│ └─ [PADDING] ← INJEÇÃO AQUI (1024)  │ ✅ Área segura
├─────────────────────────────────────┤
│ Código Executável                   │
├─────────────────────────────────────┤
│ Dados e Recursos                    │
└─────────────────────────────────────┘

Tamanho: MANTIDO (in-place modification)
```

### Método Append (.pag)
```
┌─────────────────────────────────────┐
│ Conteúdo Original do Arquivo .pag   │
│                                     │
│ (estrutura interna preservada)      │
│                                     │
├─────────────────────────────────────┤
│ [DADOS INJETADOS] ← APPEND AQUI     │ ✅ Área segura
└─────────────────────────────────────┘

Tamanho: AUMENTA em 24 bytes
```

## Estrutura dos Dados Injetados

Cada modificação injeta **24 bytes**:

```
┌──────────────────┬────────────────┐
│ Timestamp (16B)  │ Random (8B)    │
│ "1730073600000"  │ [0xA3, 0x7F...]│
└──────────────────┴────────────────┘
```

Isso garante:
- ✅ Hash único a cada modificação
- ✅ Impossível gerar o mesmo hash duas vezes
- ✅ Rastreabilidade (timestamp)
- ✅ Segurança (bytes aleatórios)

## Exemplos Práticos

### Exemplo 1: Modificar um instalador
```bash
# Arquivo: installer.exe (5.2 MB)
# Hash original: a1b2c3d4e5f6...
# Após modificação:
# Hash novo: 9f8e7d6c5b4a...
# Tamanho: 5.2 MB (mesmo tamanho)
# Método: PE header padding
```

### Exemplo 2: Modificar um arquivo .pag
```bash
# Arquivo: database.pag (10 MB)
# Hash original: 1a2b3c4d5e6f...
# Após modificação:
# Hash novo: f6e5d4c3b2a1...
# Tamanho: 10 MB + 24 bytes
# Método: Append to end
```

## Verificação de Integridade

### Para arquivos .exe/.dll
Você pode verificar que o arquivo ainda funciona:
```bash
# Execute o arquivo modificado
./arquivo_modificado.exe

# Compare com o original (deve funcionar igual)
```

### Para arquivos .pag
```bash
# Verifique o tamanho
ls -lh original.pag modified.pag

# A diferença deve ser exatamente 24 bytes
```

## Perguntas Frequentes

### Q: O arquivo modificado vai funcionar normalmente?
**R:** Sim! As áreas de injeção são escolhidas especificamente para não afetar a funcionalidade:
- Para .exe/.dll: usamos padding não utilizado
- Para .pag: adicionamos dados ao final (como metadata)

### Q: Posso modificar o mesmo arquivo várias vezes?
**R:** Sim! Cada modificação gerará um hash completamente diferente devido ao timestamp + aleatoriedade.

### Q: E se meu arquivo .exe estiver assinado digitalmente?
**R:** A modificação invalidará a assinatura digital. Você precisará reassinar o arquivo após a modificação usando um certificado de assinatura de código.

### Q: O hash sempre será diferente?
**R:** Sim! A combinação de timestamp (muda a cada milissegundo) + 8 bytes aleatórios garante que cada modificação seja única.

### Q: Posso remover os dados injetados depois?
**R:** 
- Para .pag: Sim, basta truncar os últimos 24 bytes do arquivo
- Para .exe/.dll: Tecnicamente sim, mas não recomendado (você precisaria saber o offset exato)

### Q: Qual é o impacto no desempenho?
**R:** Praticamente zero:
- Para .exe/.dll: sem aumento de tamanho
- Para .pag: apenas 24 bytes adicionais (insignificante)

## Testes Automatizados

Execute o script de teste incluído:
```bash
node test_modification.cjs
```

Isso testará:
- ✅ Modificação de arquivos .pag (método append)
- ✅ Modificação de arquivos .exe (método PE padding)
- ✅ Verificação de mudança de hash
- ✅ Verificação de tamanhos

## Suporte Técnico

Para mais informações, consulte:
- `README_MODIFICACOES.md` - Documentação técnica completa
- `server/routers.ts` - Código do backend
- `client/src/pages/Home.tsx` - Código do frontend

---

**Versão**: 2.0  
**Última atualização**: Outubro 2024

